/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures.pieces;

import com.google.common.collect.Lists;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.world.structures.configs.RSMansionConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.MirroringSingleJigsawPiece;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2960;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_3545;
import net.minecraft.class_3781;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5455;

public class MansionPieces {
    public static <C extends RSMansionConfig> void createMansionLayout(class_5455 dynamicRegistryManager, class_3485 manager, class_2338 pos, class_2470 rotation, List<class_3443> pieces, Random random, C config) {
        MansionParameters mansionParameters = new MansionParameters(random);
        LayoutGenerator<C> layoutGenerator = new LayoutGenerator<C>(manager, random, config);
        layoutGenerator.generate(dynamicRegistryManager, pos, rotation, pieces, mansionParameters);
    }

    static class MansionParameters {
        private final Random random;
        private final FlagMatrix field_15440;
        private final FlagMatrix field_15439;
        private final FlagMatrix[] field_15443;
        private final int field_15442;
        private final int field_15441;

        public MansionParameters(Random random) {
            this.random = random;
            this.field_15442 = 7;
            this.field_15441 = 4;
            this.field_15440 = new FlagMatrix(11, 11, 5);
            this.field_15440.fill(this.field_15442, this.field_15441, this.field_15442 + 1, this.field_15441 + 1, 3);
            this.field_15440.fill(this.field_15442 - 1, this.field_15441, this.field_15442 - 1, this.field_15441 + 1, 2);
            this.field_15440.fill(this.field_15442 + 2, this.field_15441 - 2, this.field_15442 + 3, this.field_15441 + 3, 5);
            this.field_15440.fill(this.field_15442 + 1, this.field_15441 - 2, this.field_15442 + 1, this.field_15441 - 1, 1);
            this.field_15440.fill(this.field_15442 + 1, this.field_15441 + 2, this.field_15442 + 1, this.field_15441 + 3, 1);
            this.field_15440.set(this.field_15442 - 1, this.field_15441 - 1, 1);
            this.field_15440.set(this.field_15442 - 1, this.field_15441 + 2, 1);
            this.field_15440.fill(0, 0, 11, 1, 5);
            this.field_15440.fill(0, 9, 11, 11, 5);
            this.method_15045(this.field_15440, this.field_15442, this.field_15441 - 2, class_2350.field_11039, 6);
            this.method_15045(this.field_15440, this.field_15442, this.field_15441 + 3, class_2350.field_11039, 6);
            this.method_15045(this.field_15440, this.field_15442 - 2, this.field_15441 - 1, class_2350.field_11039, 3);
            this.method_15045(this.field_15440, this.field_15442 - 2, this.field_15441 + 2, class_2350.field_11039, 3);
            while (this.method_15046(this.field_15440)) {
            }
            this.field_15443 = new FlagMatrix[3];
            this.field_15443[0] = new FlagMatrix(11, 11, 5);
            this.field_15443[1] = new FlagMatrix(11, 11, 5);
            this.field_15443[2] = new FlagMatrix(11, 11, 5);
            this.method_15042(this.field_15440, this.field_15443[0]);
            this.method_15042(this.field_15440, this.field_15443[1]);
            this.field_15443[0].fill(this.field_15442 + 1, this.field_15441, this.field_15442 + 1, this.field_15441 + 1, 0x800000);
            this.field_15443[1].fill(this.field_15442 + 1, this.field_15441, this.field_15442 + 1, this.field_15441 + 1, 0x800000);
            this.field_15439 = new FlagMatrix(this.field_15440.n, this.field_15440.m, 5);
            this.method_15048();
            this.method_15042(this.field_15439, this.field_15443[2]);
        }

        public static boolean method_15047(FlagMatrix flagMatrix, int i, int j) {
            int k = flagMatrix.get(i, j);
            return k == 1 || k == 2 || k == 3 || k == 4;
        }

        public boolean method_15039(FlagMatrix flagMatrix, int i, int j, int k, int l) {
            return (this.field_15443[k].get(i, j) & 0xFFFF) == l;
        }

        public class_2350 method_15040(FlagMatrix flagMatrix, int i, int j, int k, int l) {
            class_2350 direction;
            Iterator var6 = class_2350.class_2353.field_11062.iterator();
            do {
                if (var6.hasNext()) continue;
                return null;
            } while (!this.method_15039(flagMatrix, i + (direction = (class_2350)var6.next()).method_10148(), j + direction.method_10165(), k, l));
            return direction;
        }

        private void method_15045(FlagMatrix flagMatrix, int i, int j, class_2350 direction, int k) {
            if (k > 0) {
                class_2350 direction2;
                flagMatrix.set(i, j, 1);
                flagMatrix.update(i + direction.method_10148(), j + direction.method_10165(), 0, 1);
                for (int l = 0; l < 8; ++l) {
                    direction2 = class_2350.method_10139((int)this.random.nextInt(4));
                    if (direction2 == direction.method_10153() || direction2 == class_2350.field_11034 && this.random.nextBoolean()) continue;
                    int m = i + direction.method_10148();
                    int n = j + direction.method_10165();
                    if (flagMatrix.get(m + direction2.method_10148(), n + direction2.method_10165()) != 0 || flagMatrix.get(m + direction2.method_10148() * 2, n + direction2.method_10165() * 2) != 0) continue;
                    this.method_15045(flagMatrix, i + direction.method_10148() + direction2.method_10148(), j + direction.method_10165() + direction2.method_10165(), direction2, k - 1);
                    break;
                }
                class_2350 direction3 = direction.method_10170();
                direction2 = direction.method_10160();
                flagMatrix.update(i + direction3.method_10148(), j + direction3.method_10165(), 0, 2);
                flagMatrix.update(i + direction2.method_10148(), j + direction2.method_10165(), 0, 2);
                flagMatrix.update(i + direction.method_10148() + direction3.method_10148(), j + direction.method_10165() + direction3.method_10165(), 0, 2);
                flagMatrix.update(i + direction.method_10148() + direction2.method_10148(), j + direction.method_10165() + direction2.method_10165(), 0, 2);
                flagMatrix.update(i + direction.method_10148() * 2, j + direction.method_10165() * 2, 0, 2);
                flagMatrix.update(i + direction3.method_10148() * 2, j + direction3.method_10165() * 2, 0, 2);
                flagMatrix.update(i + direction2.method_10148() * 2, j + direction2.method_10165() * 2, 0, 2);
            }
        }

        private boolean method_15046(FlagMatrix flagMatrix) {
            boolean bl = false;
            for (int i = 0; i < flagMatrix.m; ++i) {
                for (int j = 0; j < flagMatrix.n; ++j) {
                    if (flagMatrix.get(j, i) != 0) continue;
                    int k = MansionParameters.method_15047(flagMatrix, j + 1, i) ? 1 : 0;
                    k += MansionParameters.method_15047(flagMatrix, j - 1, i) ? 1 : 0;
                    k += MansionParameters.method_15047(flagMatrix, j, i + 1) ? 1 : 0;
                    if ((k += MansionParameters.method_15047(flagMatrix, j, i - 1) ? 1 : 0) >= 3) {
                        flagMatrix.set(j, i, 2);
                        bl = true;
                        continue;
                    }
                    if (k != 2) continue;
                    int l = MansionParameters.method_15047(flagMatrix, j + 1, i + 1) ? 1 : 0;
                    l += MansionParameters.method_15047(flagMatrix, j - 1, i + 1) ? 1 : 0;
                    l += MansionParameters.method_15047(flagMatrix, j + 1, i - 1) ? 1 : 0;
                    if ((l += MansionParameters.method_15047(flagMatrix, j - 1, i - 1) ? 1 : 0) > 1) continue;
                    flagMatrix.set(j, i, 2);
                    bl = true;
                }
            }
            return bl;
        }

        private void method_15048() {
            int n;
            int m;
            ArrayList list = Lists.newArrayList();
            FlagMatrix flagMatrix = this.field_15443[1];
            for (int i = 0; i < this.field_15439.m; ++i) {
                for (m = 0; m < this.field_15439.n; ++m) {
                    int k = flagMatrix.get(m, i);
                    n = k & 0xF0000;
                    if (n != 131072 || (k & 0x200000) != 0x200000) continue;
                    list.add(new class_3545((Object)m, (Object)i));
                }
            }
            if (list.isEmpty()) {
                this.field_15439.fill(0, 0, this.field_15439.n, this.field_15439.m, 5);
            } else {
                class_3545 pair = (class_3545)list.get(this.random.nextInt(list.size()));
                m = flagMatrix.get((Integer)pair.method_15442(), (Integer)pair.method_15441());
                flagMatrix.set((Integer)pair.method_15442(), (Integer)pair.method_15441(), m | 0x400000);
                class_2350 direction = this.method_15040(this.field_15440, (Integer)pair.method_15442(), (Integer)pair.method_15441(), 1, m & 0xFFFF);
                n = (Integer)pair.method_15442() + direction.method_10148();
                int o = (Integer)pair.method_15441() + direction.method_10165();
                for (int p = 0; p < this.field_15439.m; ++p) {
                    for (int q = 0; q < this.field_15439.n; ++q) {
                        if (!MansionParameters.method_15047(this.field_15440, q, p)) {
                            this.field_15439.set(q, p, 5);
                            continue;
                        }
                        if (q == (Integer)pair.method_15442() && p == (Integer)pair.method_15441()) {
                            this.field_15439.set(q, p, 3);
                            continue;
                        }
                        if (q != n || p != o) continue;
                        this.field_15439.set(q, p, 3);
                        this.field_15443[2].set(q, p, 0x800000);
                    }
                }
                ArrayList list2 = Lists.newArrayList();
                for (class_2350 direction2 : class_2350.class_2353.field_11062) {
                    if (this.field_15439.get(n + direction2.method_10148(), o + direction2.method_10165()) != 0) continue;
                    list2.add(direction2);
                }
                if (list2.isEmpty()) {
                    this.field_15439.fill(0, 0, this.field_15439.n, this.field_15439.m, 5);
                    flagMatrix.set((Integer)pair.method_15442(), (Integer)pair.method_15441(), m);
                } else {
                    class_2350 direction3 = (class_2350)list2.get(this.random.nextInt(list2.size()));
                    this.method_15045(this.field_15439, n + direction3.method_10148(), o + direction3.method_10165(), direction3, 4);
                    while (this.method_15046(this.field_15439)) {
                    }
                }
            }
        }

        private void method_15042(FlagMatrix flagMatrix, FlagMatrix flagMatrix2) {
            int k;
            ArrayList list = Lists.newArrayList();
            for (k = 0; k < flagMatrix.m; ++k) {
                for (int j = 0; j < flagMatrix.n; ++j) {
                    if (flagMatrix.get(j, k) != 2) continue;
                    list.add(new class_3545((Object)j, (Object)k));
                }
            }
            Collections.shuffle(list, this.random);
            k = 10;
            Iterator var19 = list.iterator();
            while (var19.hasNext()) {
                int m;
                class_3545 pair = (class_3545)var19.next();
                int l = (Integer)pair.method_15442();
                if (flagMatrix2.get(l, m = ((Integer)pair.method_15441()).intValue()) != 0) continue;
                int n = l;
                int o = l;
                int p = m;
                int q = m;
                int r = 65536;
                if (flagMatrix2.get(l + 1, m) == 0 && flagMatrix2.get(l, m + 1) == 0 && flagMatrix2.get(l + 1, m + 1) == 0 && flagMatrix.get(l + 1, m) == 2 && flagMatrix.get(l, m + 1) == 2 && flagMatrix.get(l + 1, m + 1) == 2) {
                    o = l + 1;
                    q = m + 1;
                    r = 262144;
                } else if (flagMatrix2.get(l - 1, m) == 0 && flagMatrix2.get(l, m + 1) == 0 && flagMatrix2.get(l - 1, m + 1) == 0 && flagMatrix.get(l - 1, m) == 2 && flagMatrix.get(l, m + 1) == 2 && flagMatrix.get(l - 1, m + 1) == 2) {
                    n = l - 1;
                    q = m + 1;
                    r = 262144;
                } else if (flagMatrix2.get(l - 1, m) == 0 && flagMatrix2.get(l, m - 1) == 0 && flagMatrix2.get(l - 1, m - 1) == 0 && flagMatrix.get(l - 1, m) == 2 && flagMatrix.get(l, m - 1) == 2 && flagMatrix.get(l - 1, m - 1) == 2) {
                    n = l - 1;
                    p = m - 1;
                    r = 262144;
                } else if (flagMatrix2.get(l + 1, m) == 0 && flagMatrix.get(l + 1, m) == 2) {
                    o = l + 1;
                    r = 131072;
                } else if (flagMatrix2.get(l, m + 1) == 0 && flagMatrix.get(l, m + 1) == 2) {
                    q = m + 1;
                    r = 131072;
                } else if (flagMatrix2.get(l - 1, m) == 0 && flagMatrix.get(l - 1, m) == 2) {
                    n = l - 1;
                    r = 131072;
                } else if (flagMatrix2.get(l, m - 1) == 0 && flagMatrix.get(l, m - 1) == 2) {
                    p = m - 1;
                    r = 131072;
                }
                int s = this.random.nextBoolean() ? n : o;
                int t = this.random.nextBoolean() ? p : q;
                int u = 0x200000;
                if (!flagMatrix.anyMatchAround(s, t, 1)) {
                    s = s == n ? o : n;
                    int n2 = t = t == p ? q : p;
                    if (!flagMatrix.anyMatchAround(s, t, 1)) {
                        int n3 = t = t == p ? q : p;
                        if (!flagMatrix.anyMatchAround(s, t, 1)) {
                            s = s == n ? o : n;
                            int n4 = t = t == p ? q : p;
                            if (!flagMatrix.anyMatchAround(s, t, 1)) {
                                u = 0;
                                s = n;
                                t = p;
                            }
                        }
                    }
                }
                for (int v = p; v <= q; ++v) {
                    for (int w = n; w <= o; ++w) {
                        if (w == s && v == t) {
                            flagMatrix2.set(w, v, 0x100000 | u | r | k);
                            continue;
                        }
                        flagMatrix2.set(w, v, r | k);
                    }
                }
                ++k;
            }
            return;
        }
    }

    static class LayoutGenerator<C extends RSMansionConfig> {
        private final class_3485 manager;
        private final Random random;
        private final C config;
        private int field_15446;
        private int field_15445;

        public LayoutGenerator(class_3485 manager, Random random, C config) {
            this.manager = manager;
            this.random = random;
            this.config = config;
        }

        public void generate(class_5455 dynamicRegistryManager, class_2338 pos, class_2470 rotation, List<class_3443> structurePieces, MansionParameters mansionParameters) {
            int floorLevel;
            class_2378 poolRegistry = dynamicRegistryManager.method_33309(class_2378.field_25917);
            GenerationPiece generationPiece = new GenerationPiece();
            generationPiece.position = pos;
            generationPiece.rotation = rotation;
            generationPiece.template = "wall_flat";
            GenerationPiece generationPiece2 = new GenerationPiece();
            this.addEntrance((class_2378<class_3785>)poolRegistry, structurePieces, generationPiece);
            generationPiece2.position = generationPiece.position.method_10086(8);
            generationPiece2.rotation = generationPiece.rotation;
            generationPiece2.template = "wall_window";
            FlagMatrix flagMatrix = mansionParameters.field_15440;
            FlagMatrix flagMatrix2 = mansionParameters.field_15439;
            this.field_15446 = mansionParameters.field_15442 + 1;
            this.field_15445 = mansionParameters.field_15441 + 1;
            int i = mansionParameters.field_15442 + 1;
            int j = mansionParameters.field_15441;
            this.addRoof((class_2378<class_3785>)poolRegistry, structurePieces, generationPiece, flagMatrix, class_2350.field_11035, this.field_15446, this.field_15445, i, j);
            this.addRoof((class_2378<class_3785>)poolRegistry, structurePieces, generationPiece2, flagMatrix, class_2350.field_11035, this.field_15446, this.field_15445, i, j);
            GenerationPiece generationPiece3 = new GenerationPiece();
            generationPiece3.position = generationPiece.position.method_10086(19);
            generationPiece3.rotation = generationPiece.rotation;
            generationPiece3.template = "wall_window";
            boolean bl = false;
            for (int k = 0; k < flagMatrix2.m && !bl; ++k) {
                for (floorLevel = flagMatrix2.n - 1; floorLevel >= 0 && !bl; --floorLevel) {
                    if (!MansionParameters.method_15047(flagMatrix2, floorLevel, k)) continue;
                    generationPiece3.position = generationPiece3.position.method_10079(rotation.method_10503(class_2350.field_11035), 8 + (k - this.field_15445) * 8);
                    generationPiece3.position = generationPiece3.position.method_10079(rotation.method_10503(class_2350.field_11034), (floorLevel - this.field_15446) * 8);
                    this.method_15052((class_2378<class_3785>)poolRegistry, structurePieces, generationPiece3);
                    this.addRoof((class_2378<class_3785>)poolRegistry, structurePieces, generationPiece3, flagMatrix2, class_2350.field_11035, floorLevel, k, floorLevel, k);
                    bl = true;
                }
            }
            this.method_15055((class_2378<class_3785>)poolRegistry, structurePieces, pos.method_10086(16), rotation, flagMatrix, flagMatrix2);
            this.method_15055((class_2378<class_3785>)poolRegistry, structurePieces, pos.method_10086(27), rotation, flagMatrix2, null);
            List<ThirdFloor<C>> roomCollections = List.of(new FirstFloor<C>(this.config), new SecondFloor<C>(this.config), new ThirdFloor<C>(this.config));
            for (floorLevel = 0; floorLevel < 3; ++floorLevel) {
                class_2338 blockPos = pos.method_10086(8 * floorLevel + (floorLevel == 2 ? 3 : 0));
                FlagMatrix flagMatrix3 = mansionParameters.field_15443[floorLevel];
                FlagMatrix flagMatrix4 = floorLevel == 2 ? flagMatrix2 : flagMatrix;
                String string = floorLevel == 0 ? "carpet_south_1" : "carpet_south_2";
                String string2 = floorLevel == 0 ? "carpet_west_1" : "carpet_west_2";
                for (int n = 0; n < flagMatrix4.m; ++n) {
                    for (int o = 0; o < flagMatrix4.n; ++o) {
                        if (flagMatrix4.get(o, n) != 1) continue;
                        class_2338 blockPos2 = blockPos.method_10079(rotation.method_10503(class_2350.field_11035), 8 + (n - this.field_15445) * 8);
                        blockPos2 = blockPos2.method_10079(rotation.method_10503(class_2350.field_11034), (o - this.field_15446) * 8);
                        structurePieces.add(this.getJigsawPiece((class_2378<class_3785>)poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + (floorLevel == 0 ? "/corridor_floor" : "/corridor_floor_high"), blockPos2, rotation, class_2415.field_11302));
                        if (flagMatrix4.get(o, n - 1) == 1 || (flagMatrix3.get(o, n - 1) & 0x800000) == 0x800000) {
                            structurePieces.add(this.getJigsawPiece((class_2378<class_3785>)poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/carpet_north", blockPos2.method_10079(rotation.method_10503(class_2350.field_11034), 1).method_10084(), rotation, class_2415.field_11302));
                        }
                        if (flagMatrix4.get(o + 1, n) == 1 || (flagMatrix3.get(o + 1, n) & 0x800000) == 0x800000) {
                            structurePieces.add(this.getJigsawPiece((class_2378<class_3785>)poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/carpet_east", blockPos2.method_10079(rotation.method_10503(class_2350.field_11035), 1).method_10079(rotation.method_10503(class_2350.field_11034), 5).method_10084(), rotation, class_2415.field_11302));
                        }
                        if (flagMatrix4.get(o, n + 1) == 1 || (flagMatrix3.get(o, n + 1) & 0x800000) == 0x800000) {
                            structurePieces.add(this.getJigsawPiece((class_2378<class_3785>)poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/" + string, blockPos2.method_10079(rotation.method_10503(class_2350.field_11035), 5).method_10079(rotation.method_10503(class_2350.field_11039), 1), rotation, class_2415.field_11302));
                        }
                        if (flagMatrix4.get(o - 1, n) != 1 && (flagMatrix3.get(o - 1, n) & 0x800000) != 0x800000) continue;
                        structurePieces.add(this.getJigsawPiece((class_2378<class_3785>)poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/" + string2, blockPos2.method_10079(rotation.method_10503(class_2350.field_11039), 1).method_10079(rotation.method_10503(class_2350.field_11043), 1), rotation, class_2415.field_11302));
                    }
                }
                String string3 = floorLevel == 0 ? "indoors_wall_1" : "indoors_wall_2";
                String string4 = floorLevel == 0 ? "indoors_door_1" : "indoors_door_2";
                ArrayList list = Lists.newArrayList();
                for (int p = 0; p < flagMatrix4.m; ++p) {
                    for (int q = 0; q < flagMatrix4.n; ++q) {
                        class_2350 direction4;
                        class_2338 blockPos6;
                        boolean bl2;
                        boolean bl3 = bl2 = floorLevel == 2 && flagMatrix4.get(q, p) == 3;
                        if (flagMatrix4.get(q, p) != 2 && !bl2) continue;
                        int r = flagMatrix3.get(q, p);
                        int s = r & 0xF0000;
                        int t = r & 0xFFFF;
                        bl2 = bl2 && (r & 0x800000) == 0x800000;
                        list.clear();
                        if ((r & 0x200000) == 0x200000) {
                            for (class_2350 direction : class_2350.class_2353.field_11062) {
                                if (flagMatrix4.get(q + direction.method_10148(), p + direction.method_10165()) != 1) continue;
                                list.add(direction);
                            }
                        }
                        class_2350 direction2 = null;
                        if (!list.isEmpty()) {
                            direction2 = (class_2350)list.get(this.random.nextInt(list.size()));
                        } else if ((r & 0x100000) == 0x100000) {
                            direction2 = class_2350.field_11036;
                        }
                        class_2338 blockPos3 = blockPos.method_10079(rotation.method_10503(class_2350.field_11035), 8 + (p - this.field_15445) * 8);
                        blockPos3 = blockPos3.method_10079(rotation.method_10503(class_2350.field_11034), -1 + (q - this.field_15446) * 8);
                        if (MansionParameters.method_15047(flagMatrix4, q - 1, p) && !mansionParameters.method_15039(flagMatrix4, q - 1, p, floorLevel, t)) {
                            structurePieces.add(this.getJigsawPiece((class_2378<class_3785>)poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/" + (direction2 == class_2350.field_11039 ? string4 : string3), blockPos3, rotation, class_2415.field_11302));
                        }
                        if (flagMatrix4.get(q + 1, p) == 1 && !bl2) {
                            blockPos6 = blockPos3.method_10079(rotation.method_10503(class_2350.field_11034), 8);
                            structurePieces.add(this.getJigsawPiece((class_2378<class_3785>)poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/" + (direction2 == class_2350.field_11034 ? string4 : string3), blockPos6, rotation, class_2415.field_11302));
                        }
                        if (MansionParameters.method_15047(flagMatrix4, q, p + 1) && !mansionParameters.method_15039(flagMatrix4, q, p + 1, floorLevel, t)) {
                            blockPos6 = blockPos3.method_10079(rotation.method_10503(class_2350.field_11035), 7);
                            blockPos6 = blockPos6.method_10079(rotation.method_10503(class_2350.field_11034), 7);
                            structurePieces.add(this.getJigsawPiece((class_2378<class_3785>)poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/" + (direction2 == class_2350.field_11035 ? string4 : string3), blockPos6, rotation.method_10501(class_2470.field_11463), class_2415.field_11302));
                        }
                        if (flagMatrix4.get(q, p - 1) == 1 && !bl2) {
                            blockPos6 = blockPos3.method_10079(rotation.method_10503(class_2350.field_11043), 1);
                            blockPos6 = blockPos6.method_10079(rotation.method_10503(class_2350.field_11034), 7);
                            structurePieces.add(this.getJigsawPiece((class_2378<class_3785>)poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/" + (direction2 == class_2350.field_11043 ? string4 : string3), blockPos6, rotation.method_10501(class_2470.field_11463), class_2415.field_11302));
                        }
                        if (s == 65536) {
                            this.addSmallRoom((class_2378<class_3785>)poolRegistry, structurePieces, blockPos3, rotation, direction2, roomCollections.get(floorLevel));
                            continue;
                        }
                        if (s == 131072 && direction2 != null) {
                            direction4 = mansionParameters.method_15040(flagMatrix4, q, p, floorLevel, t);
                            boolean bl32 = (r & 0x400000) == 0x400000;
                            this.addMediumRoom((class_2378<class_3785>)poolRegistry, structurePieces, blockPos3, rotation, direction4, direction2, roomCollections.get(floorLevel), bl32);
                            continue;
                        }
                        if (s == 262144 && direction2 != null && direction2 != class_2350.field_11036) {
                            direction4 = direction2.method_10170();
                            if (!mansionParameters.method_15039(flagMatrix4, q + direction4.method_10148(), p + direction4.method_10165(), floorLevel, t)) {
                                direction4 = direction4.method_10153();
                            }
                            this.addBigRoom((class_2378<class_3785>)poolRegistry, structurePieces, blockPos3, rotation, direction4, direction2, roomCollections.get(floorLevel));
                            continue;
                        }
                        if (s != 262144 || direction2 != class_2350.field_11036) continue;
                        this.addBigSecretRoom((class_2378<class_3785>)poolRegistry, structurePieces, blockPos3, rotation, roomCollections.get(floorLevel));
                    }
                }
            }
        }

        private <C extends RSMansionConfig> void addRoof(class_2378<class_3785> poolRegistry, List<class_3443> list, GenerationPiece generationPiece, FlagMatrix flagMatrix, class_2350 direction, int i, int j, int k, int l) {
            int m = i;
            int n = j;
            class_2350 direction2 = direction;
            do {
                if (!MansionParameters.method_15047(flagMatrix, m + direction.method_10148(), n + direction.method_10165())) {
                    this.method_15058(poolRegistry, list, generationPiece);
                    direction = direction.method_10170();
                    if (m == k && n == l && direction2 == direction) continue;
                    this.method_15052(poolRegistry, list, generationPiece);
                    continue;
                }
                if (MansionParameters.method_15047(flagMatrix, m + direction.method_10148(), n + direction.method_10165()) && MansionParameters.method_15047(flagMatrix, m + direction.method_10148() + direction.method_10160().method_10148(), n + direction.method_10165() + direction.method_10160().method_10165())) {
                    this.method_15060(generationPiece);
                    m += direction.method_10148();
                    n += direction.method_10165();
                    direction = direction.method_10160();
                    continue;
                }
                if ((m += direction.method_10148()) == k && (n += direction.method_10165()) == l && direction2 == direction) continue;
                this.method_15052(poolRegistry, list, generationPiece);
            } while (m != k || n != l || direction2 != direction);
        }

        private void method_15055(class_2378<class_3785> poolRegistry, List<class_3443> structurePieces, class_2338 blockPos, class_2470 rotation, FlagMatrix flagMatrix, FlagMatrix flagMatrix2) {
            class_2338 blockPos15;
            boolean bl3;
            class_2338 blockPos7;
            int l;
            int k;
            for (k = 0; k < flagMatrix.m; ++k) {
                for (l = 0; l < flagMatrix.n; ++l) {
                    blockPos7 = blockPos.method_10079(rotation.method_10503(class_2350.field_11035), 8 + (k - this.field_15445) * 8);
                    blockPos7 = blockPos7.method_10079(rotation.method_10503(class_2350.field_11034), (l - this.field_15446) * 8);
                    boolean bl = bl3 = flagMatrix2 != null && MansionParameters.method_15047(flagMatrix2, l, k);
                    if (!MansionParameters.method_15047(flagMatrix, l, k) || bl3) continue;
                    structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/roof", blockPos7.method_10086(3), rotation, class_2415.field_11302));
                    if (!MansionParameters.method_15047(flagMatrix, l + 1, k)) {
                        blockPos15 = blockPos7.method_10079(rotation.method_10503(class_2350.field_11034), 6);
                        structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/roof_front", blockPos15, rotation, class_2415.field_11302));
                    }
                    if (!MansionParameters.method_15047(flagMatrix, l - 1, k)) {
                        blockPos15 = blockPos7.method_10079(rotation.method_10503(class_2350.field_11034), 0);
                        blockPos15 = blockPos15.method_10079(rotation.method_10503(class_2350.field_11035), 7);
                        structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/roof_front", blockPos15, rotation.method_10501(class_2470.field_11464), class_2415.field_11302));
                    }
                    if (!MansionParameters.method_15047(flagMatrix, l, k - 1)) {
                        blockPos15 = blockPos7.method_10079(rotation.method_10503(class_2350.field_11039), 1);
                        structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/roof_front", blockPos15, rotation.method_10501(class_2470.field_11465), class_2415.field_11302));
                    }
                    if (MansionParameters.method_15047(flagMatrix, l, k + 1)) continue;
                    blockPos15 = blockPos7.method_10079(rotation.method_10503(class_2350.field_11034), 6);
                    blockPos15 = blockPos15.method_10079(rotation.method_10503(class_2350.field_11035), 6);
                    structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/roof_front", blockPos15, rotation.method_10501(class_2470.field_11463), class_2415.field_11302));
                }
            }
            if (flagMatrix2 != null) {
                for (k = 0; k < flagMatrix.m; ++k) {
                    for (l = 0; l < flagMatrix.n; ++l) {
                        blockPos7 = blockPos.method_10079(rotation.method_10503(class_2350.field_11035), 8 + (k - this.field_15445) * 8);
                        blockPos7 = blockPos7.method_10079(rotation.method_10503(class_2350.field_11034), (l - this.field_15446) * 8);
                        bl3 = MansionParameters.method_15047(flagMatrix2, l, k);
                        if (!MansionParameters.method_15047(flagMatrix, l, k) || !bl3) continue;
                        if (!MansionParameters.method_15047(flagMatrix, l + 1, k)) {
                            blockPos15 = blockPos7.method_10079(rotation.method_10503(class_2350.field_11034), 7);
                            blockPos15 = blockPos15.method_10079(rotation.method_10503(class_2350.field_11043), 1);
                            structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/small_wall", blockPos15, rotation, class_2415.field_11302));
                        }
                        if (!MansionParameters.method_15047(flagMatrix, l - 1, k)) {
                            blockPos15 = blockPos7.method_10079(rotation.method_10503(class_2350.field_11039), 1);
                            blockPos15 = blockPos15.method_10079(rotation.method_10503(class_2350.field_11035), 7);
                            structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/small_wall", blockPos15, rotation.method_10501(class_2470.field_11464), class_2415.field_11302));
                        }
                        if (!MansionParameters.method_15047(flagMatrix, l, k - 1)) {
                            blockPos15 = blockPos7.method_10079(rotation.method_10503(class_2350.field_11039), 1);
                            blockPos15 = blockPos15.method_10079(rotation.method_10503(class_2350.field_11043), 1);
                            structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/small_wall", blockPos15, rotation.method_10501(class_2470.field_11465), class_2415.field_11302));
                        }
                        if (!MansionParameters.method_15047(flagMatrix, l, k + 1)) {
                            blockPos15 = blockPos7.method_10079(rotation.method_10503(class_2350.field_11034), 7);
                            blockPos15 = blockPos15.method_10079(rotation.method_10503(class_2350.field_11035), 7);
                            structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/small_wall", blockPos15, rotation.method_10501(class_2470.field_11463), class_2415.field_11302));
                        }
                        if (!MansionParameters.method_15047(flagMatrix, l + 1, k)) {
                            if (!MansionParameters.method_15047(flagMatrix, l, k - 1)) {
                                blockPos15 = blockPos7.method_10079(rotation.method_10503(class_2350.field_11034), 7);
                                blockPos15 = blockPos15.method_10079(rotation.method_10503(class_2350.field_11043), 2);
                                structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/small_wall_corner", blockPos15, rotation, class_2415.field_11302));
                            }
                            if (!MansionParameters.method_15047(flagMatrix, l, k + 1)) {
                                blockPos15 = blockPos7.method_10079(rotation.method_10503(class_2350.field_11034), 8);
                                blockPos15 = blockPos15.method_10079(rotation.method_10503(class_2350.field_11035), 7);
                                structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/small_wall_corner", blockPos15, rotation.method_10501(class_2470.field_11463), class_2415.field_11302));
                            }
                        }
                        if (MansionParameters.method_15047(flagMatrix, l - 1, k)) continue;
                        if (!MansionParameters.method_15047(flagMatrix, l, k - 1)) {
                            blockPos15 = blockPos7.method_10079(rotation.method_10503(class_2350.field_11039), 2);
                            blockPos15 = blockPos15.method_10079(rotation.method_10503(class_2350.field_11043), 1);
                            structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/small_wall_corner", blockPos15, rotation.method_10501(class_2470.field_11465), class_2415.field_11302));
                        }
                        if (MansionParameters.method_15047(flagMatrix, l, k + 1)) continue;
                        blockPos15 = blockPos7.method_10079(rotation.method_10503(class_2350.field_11039), 1);
                        blockPos15 = blockPos15.method_10079(rotation.method_10503(class_2350.field_11035), 8);
                        structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/small_wall_corner", blockPos15, rotation.method_10501(class_2470.field_11464), class_2415.field_11302));
                    }
                }
            }
            for (k = 0; k < flagMatrix.m; ++k) {
                for (l = 0; l < flagMatrix.n; ++l) {
                    class_2338 blockPos24;
                    blockPos7 = blockPos.method_10079(rotation.method_10503(class_2350.field_11035), 8 + (k - this.field_15445) * 8);
                    blockPos7 = blockPos7.method_10079(rotation.method_10503(class_2350.field_11034), (l - this.field_15446) * 8);
                    boolean bl = bl3 = flagMatrix2 != null && MansionParameters.method_15047(flagMatrix2, l, k);
                    if (!MansionParameters.method_15047(flagMatrix, l, k) || bl3) continue;
                    if (!MansionParameters.method_15047(flagMatrix, l + 1, k)) {
                        blockPos15 = blockPos7.method_10079(rotation.method_10503(class_2350.field_11034), 6);
                        if (!MansionParameters.method_15047(flagMatrix, l, k + 1)) {
                            blockPos24 = blockPos15.method_10079(rotation.method_10503(class_2350.field_11035), 6);
                            structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/roof_corner", blockPos24, rotation, class_2415.field_11302));
                        } else if (MansionParameters.method_15047(flagMatrix, l + 1, k + 1)) {
                            blockPos24 = blockPos15.method_10079(rotation.method_10503(class_2350.field_11035), 5);
                            structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/roof_inner_corner", blockPos24, rotation, class_2415.field_11302));
                        }
                        if (!MansionParameters.method_15047(flagMatrix, l, k - 1)) {
                            structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/roof_corner", blockPos15, rotation.method_10501(class_2470.field_11465), class_2415.field_11302));
                        } else if (MansionParameters.method_15047(flagMatrix, l + 1, k - 1)) {
                            blockPos24 = blockPos7.method_10079(rotation.method_10503(class_2350.field_11034), 9);
                            blockPos24 = blockPos24.method_10079(rotation.method_10503(class_2350.field_11043), 2);
                            structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/roof_inner_corner", blockPos24, rotation.method_10501(class_2470.field_11463), class_2415.field_11302));
                        }
                    }
                    if (MansionParameters.method_15047(flagMatrix, l - 1, k)) continue;
                    blockPos15 = blockPos7.method_10079(rotation.method_10503(class_2350.field_11034), 0);
                    blockPos15 = blockPos15.method_10079(rotation.method_10503(class_2350.field_11035), 0);
                    if (!MansionParameters.method_15047(flagMatrix, l, k + 1)) {
                        blockPos24 = blockPos15.method_10079(rotation.method_10503(class_2350.field_11035), 6);
                        structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/roof_corner", blockPos24, rotation.method_10501(class_2470.field_11463), class_2415.field_11302));
                    } else if (MansionParameters.method_15047(flagMatrix, l - 1, k + 1)) {
                        blockPos24 = blockPos15.method_10079(rotation.method_10503(class_2350.field_11035), 8);
                        blockPos24 = blockPos24.method_10079(rotation.method_10503(class_2350.field_11039), 3);
                        structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/roof_inner_corner", blockPos24, rotation.method_10501(class_2470.field_11465), class_2415.field_11302));
                    }
                    if (!MansionParameters.method_15047(flagMatrix, l, k - 1)) {
                        structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/roof_corner", blockPos15, rotation.method_10501(class_2470.field_11464), class_2415.field_11302));
                        continue;
                    }
                    if (!MansionParameters.method_15047(flagMatrix, l - 1, k - 1)) continue;
                    blockPos24 = blockPos15.method_10079(rotation.method_10503(class_2350.field_11035), 1);
                    structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/roof_inner_corner", blockPos24, rotation.method_10501(class_2470.field_11464), class_2415.field_11302));
                }
            }
        }

        private void addEntrance(class_2378<class_3785> poolRegistry, List<class_3443> structurePieces, GenerationPiece generationPiece) {
            class_2350 direction = generationPiece.rotation.method_10503(class_2350.field_11039);
            structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/entrance", generationPiece.position.method_10079(direction, 9), generationPiece.rotation, class_2415.field_11302));
            generationPiece.position = generationPiece.position.method_10079(generationPiece.rotation.method_10503(class_2350.field_11035), 16);
        }

        private void method_15052(class_2378<class_3785> poolRegistry, List<class_3443> structurePieces, GenerationPiece generationPiece) {
            structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/" + generationPiece.template, generationPiece.position.method_10079(generationPiece.rotation.method_10503(class_2350.field_11034), 7), generationPiece.rotation, class_2415.field_11302));
            generationPiece.position = generationPiece.position.method_10079(generationPiece.rotation.method_10503(class_2350.field_11035), 8);
        }

        private void method_15058(class_2378<class_3785> poolRegistry, List<class_3443> structurePieces, GenerationPiece generationPiece) {
            generationPiece.position = generationPiece.position.method_10079(generationPiece.rotation.method_10503(class_2350.field_11035), -1);
            structurePieces.add(this.getJigsawPiece(poolRegistry, "repurposed_structures:mansions/" + ((RSMansionConfig)this.config).mansionType + "/wall_corner", generationPiece.position, generationPiece.rotation, class_2415.field_11302));
            generationPiece.position = generationPiece.position.method_10079(generationPiece.rotation.method_10503(class_2350.field_11035), -7);
            generationPiece.position = generationPiece.position.method_10079(generationPiece.rotation.method_10503(class_2350.field_11039), -6);
            generationPiece.rotation = generationPiece.rotation.method_10501(class_2470.field_11463);
        }

        private void method_15060(GenerationPiece generationPiece) {
            generationPiece.position = generationPiece.position.method_10079(generationPiece.rotation.method_10503(class_2350.field_11035), 6);
            generationPiece.position = generationPiece.position.method_10079(generationPiece.rotation.method_10503(class_2350.field_11034), 8);
            generationPiece.rotation = generationPiece.rotation.method_10501(class_2470.field_11465);
        }

        private void addSmallRoom(class_2378<class_3785> poolRegistry, List<class_3443> structurePieces, class_2338 blockPos, class_2470 blockRotation, class_2350 direction, RoomCollection<C> roomCollection) {
            class_2470 blockRotation2 = class_2470.field_11467;
            String string = roomCollection.get1x1(this.random);
            if (direction != class_2350.field_11034) {
                if (direction == class_2350.field_11043) {
                    blockRotation2 = blockRotation2.method_10501(class_2470.field_11465);
                } else if (direction == class_2350.field_11039) {
                    blockRotation2 = blockRotation2.method_10501(class_2470.field_11464);
                } else if (direction == class_2350.field_11035) {
                    blockRotation2 = blockRotation2.method_10501(class_2470.field_11463);
                } else {
                    string = roomCollection.get1x1Secret(this.random);
                }
            }
            class_2338 blockPos2 = class_3499.method_15162((class_2338)new class_2338(1, 0, 0), (class_2415)class_2415.field_11302, (class_2470)blockRotation2, (int)7, (int)7);
            blockRotation2 = blockRotation2.method_10501(blockRotation);
            blockPos2 = blockPos2.method_10070(blockRotation);
            class_2338 blockPos3 = blockPos.method_10069(blockPos2.method_10263(), 0, blockPos2.method_10260());
            structurePieces.add(this.getJigsawPiece(poolRegistry, string, blockPos3, blockRotation2, class_2415.field_11302));
        }

        private void addMediumRoom(class_2378<class_3785> poolRegistry, List<class_3443> structurePieces, class_2338 blockPos, class_2470 blockRotation, class_2350 direction, class_2350 direction2, RoomCollection<C> roomCollection, boolean staircase) {
            if (direction2 == class_2350.field_11034 && direction == class_2350.field_11035) {
                class_2338 blockPos15 = blockPos.method_10079(blockRotation.method_10503(class_2350.field_11034), 1);
                structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get1x2SideEntrance(this.random, staircase), blockPos15, blockRotation, class_2415.field_11302));
            } else if (direction2 == class_2350.field_11034 && direction == class_2350.field_11043) {
                class_2338 blockPos15 = blockPos.method_10079(blockRotation.method_10503(class_2350.field_11034), 1);
                blockPos15 = blockPos15.method_10079(blockRotation.method_10503(class_2350.field_11035), 6);
                structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get1x2SideEntrance(this.random, staircase), blockPos15, blockRotation, class_2415.field_11300));
            } else if (direction2 == class_2350.field_11039 && direction == class_2350.field_11043) {
                class_2338 blockPos15 = blockPos.method_10079(blockRotation.method_10503(class_2350.field_11034), 7);
                blockPos15 = blockPos15.method_10079(blockRotation.method_10503(class_2350.field_11035), 6);
                structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get1x2SideEntrance(this.random, staircase), blockPos15, blockRotation.method_10501(class_2470.field_11464), class_2415.field_11302));
            } else if (direction2 == class_2350.field_11039 && direction == class_2350.field_11035) {
                class_2338 blockPos15 = blockPos.method_10079(blockRotation.method_10503(class_2350.field_11034), 7);
                structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get1x2SideEntrance(this.random, staircase), blockPos15, blockRotation, class_2415.field_11301));
            } else if (direction2 == class_2350.field_11035 && direction == class_2350.field_11034) {
                class_2338 blockPos15 = blockPos.method_10079(blockRotation.method_10503(class_2350.field_11034), 1);
                structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get1x2SideEntrance(this.random, staircase), blockPos15, blockRotation.method_10501(class_2470.field_11463), class_2415.field_11300));
            } else if (direction2 == class_2350.field_11035 && direction == class_2350.field_11039) {
                class_2338 blockPos15 = blockPos.method_10079(blockRotation.method_10503(class_2350.field_11034), 7);
                structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get1x2SideEntrance(this.random, staircase), blockPos15, blockRotation.method_10501(class_2470.field_11463), class_2415.field_11302));
            } else if (direction2 == class_2350.field_11043 && direction == class_2350.field_11039) {
                class_2338 blockPos15 = blockPos.method_10079(blockRotation.method_10503(class_2350.field_11034), 7);
                blockPos15 = blockPos15.method_10079(blockRotation.method_10503(class_2350.field_11035), 6);
                structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get1x2SideEntrance(this.random, staircase), blockPos15, blockRotation.method_10501(class_2470.field_11463), class_2415.field_11301));
            } else if (direction2 == class_2350.field_11043 && direction == class_2350.field_11034) {
                class_2338 blockPos15 = blockPos.method_10079(blockRotation.method_10503(class_2350.field_11034), 1);
                blockPos15 = blockPos15.method_10079(blockRotation.method_10503(class_2350.field_11035), 6);
                structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get1x2SideEntrance(this.random, staircase), blockPos15, blockRotation.method_10501(class_2470.field_11465), class_2415.field_11302));
            } else if (direction2 == class_2350.field_11035 && direction == class_2350.field_11043) {
                class_2338 blockPos15 = blockPos.method_10079(blockRotation.method_10503(class_2350.field_11034), 1);
                blockPos15 = blockPos15.method_10079(blockRotation.method_10503(class_2350.field_11043), 8);
                structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get1x2FrontEntrance(this.random, staircase), blockPos15, blockRotation, class_2415.field_11302));
            } else if (direction2 == class_2350.field_11043 && direction == class_2350.field_11035) {
                class_2338 blockPos15 = blockPos.method_10079(blockRotation.method_10503(class_2350.field_11034), 7);
                blockPos15 = blockPos15.method_10079(blockRotation.method_10503(class_2350.field_11035), 14);
                structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get1x2FrontEntrance(this.random, staircase), blockPos15, blockRotation.method_10501(class_2470.field_11464), class_2415.field_11302));
            } else if (direction2 == class_2350.field_11039 && direction == class_2350.field_11034) {
                class_2338 blockPos15 = blockPos.method_10079(blockRotation.method_10503(class_2350.field_11034), 15);
                structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get1x2FrontEntrance(this.random, staircase), blockPos15, blockRotation.method_10501(class_2470.field_11463), class_2415.field_11302));
            } else if (direction2 == class_2350.field_11034 && direction == class_2350.field_11039) {
                class_2338 blockPos15 = blockPos.method_10079(blockRotation.method_10503(class_2350.field_11039), 7);
                blockPos15 = blockPos15.method_10079(blockRotation.method_10503(class_2350.field_11035), 6);
                structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get1x2FrontEntrance(this.random, staircase), blockPos15, blockRotation.method_10501(class_2470.field_11465), class_2415.field_11302));
            } else if (direction2 == class_2350.field_11036 && direction == class_2350.field_11034) {
                class_2338 blockPos15 = blockPos.method_10079(blockRotation.method_10503(class_2350.field_11034), 15);
                structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get1x2Secret(this.random), blockPos15, blockRotation.method_10501(class_2470.field_11463), class_2415.field_11302));
            } else if (direction2 == class_2350.field_11036 && direction == class_2350.field_11035) {
                class_2338 blockPos15 = blockPos.method_10079(blockRotation.method_10503(class_2350.field_11034), 1);
                blockPos15 = blockPos15.method_10079(blockRotation.method_10503(class_2350.field_11043), 0);
                structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get1x2Secret(this.random), blockPos15, blockRotation, class_2415.field_11302));
            }
        }

        private void addBigRoom(class_2378<class_3785> poolRegistry, List<class_3443> structurePieces, class_2338 blockPos, class_2470 blockRotation, class_2350 direction, class_2350 direction2, RoomCollection<C> roomCollection) {
            int i = 0;
            int j = 0;
            class_2470 blockRotation2 = blockRotation;
            class_2415 blockMirror = class_2415.field_11302;
            if (direction2 == class_2350.field_11034 && direction == class_2350.field_11035) {
                i = -7;
            } else if (direction2 == class_2350.field_11034 && direction == class_2350.field_11043) {
                i = -7;
                j = 6;
                blockMirror = class_2415.field_11300;
            } else if (direction2 == class_2350.field_11043 && direction == class_2350.field_11034) {
                i = 1;
                j = 14;
                blockRotation2 = blockRotation.method_10501(class_2470.field_11465);
            } else if (direction2 == class_2350.field_11043 && direction == class_2350.field_11039) {
                i = 7;
                j = 14;
                blockRotation2 = blockRotation.method_10501(class_2470.field_11465);
                blockMirror = class_2415.field_11300;
            } else if (direction2 == class_2350.field_11035 && direction == class_2350.field_11039) {
                i = 7;
                j = -8;
                blockRotation2 = blockRotation.method_10501(class_2470.field_11463);
            } else if (direction2 == class_2350.field_11035 && direction == class_2350.field_11034) {
                i = 1;
                j = -8;
                blockRotation2 = blockRotation.method_10501(class_2470.field_11463);
                blockMirror = class_2415.field_11300;
            } else if (direction2 == class_2350.field_11039 && direction == class_2350.field_11043) {
                i = 15;
                j = 6;
                blockRotation2 = blockRotation.method_10501(class_2470.field_11464);
            } else if (direction2 == class_2350.field_11039 && direction == class_2350.field_11035) {
                i = 15;
                blockMirror = class_2415.field_11301;
            }
            class_2338 blockPos2 = blockPos.method_10079(blockRotation.method_10503(class_2350.field_11034), i);
            blockPos2 = blockPos2.method_10079(blockRotation.method_10503(class_2350.field_11035), j);
            structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get2x2(this.random), blockPos2, blockRotation2, blockMirror));
        }

        private void addBigSecretRoom(class_2378<class_3785> poolRegistry, List<class_3443> structurePieces, class_2338 blockPos, class_2470 blockRotation, RoomCollection<C> roomCollection) {
            class_2338 blockPos2 = blockPos.method_10079(blockRotation.method_10503(class_2350.field_11034), 1);
            structurePieces.add(this.getJigsawPiece(poolRegistry, roomCollection.get2x2Secret(this.random), blockPos2, blockRotation, class_2415.field_11302));
        }

        private class_3443 getJigsawPiece(class_2378<class_3785> poolRegistry, String poolPath, class_2338 blockPos, class_2470 rotation, class_2415 mirror) {
            Object poolEntry;
            class_2960 resourceLocation = new class_2960(poolPath.toLowerCase(Locale.ROOT));
            class_3785 pool = (class_3785)poolRegistry.method_10223(resourceLocation);
            if (pool == null || pool.method_16632() == 0) {
                RepurposedStructures.LOGGER.warn("Repurposed Structures: Empty or nonexistent pool: {}  Will not generate mansion piece at spot.", (Object)(resourceLocation + " - Mansion type: " + ((RSMansionConfig)this.config).mansionType));
                poolEntry = (class_3784)class_3784.method_30438().apply(class_3785.class_3786.field_16687);
            } else {
                poolEntry = pool.method_16631(this.random);
                if (poolEntry instanceof class_3781) {
                    poolEntry = new MirroringSingleJigsawPiece((class_3781)poolEntry, mirror);
                }
            }
            return new class_3790(this.manager, poolEntry, blockPos, poolEntry.method_19308(), rotation, poolEntry.method_16628(this.manager, blockPos, rotation));
        }
    }

    static class GenerationPiece {
        public class_2470 rotation;
        public class_2338 position;
        public String template;

        private GenerationPiece() {
        }
    }

    static class FlagMatrix {
        private final int[][] array;
        private final int n;
        private final int m;
        private final int fallback;

        public FlagMatrix(int n, int m, int fallback) {
            this.n = n;
            this.m = m;
            this.fallback = fallback;
            this.array = new int[n][m];
        }

        public void set(int i, int j, int value) {
            if (i >= 0 && i < this.n && j >= 0 && j < this.m) {
                this.array[i][j] = value;
            }
        }

        public void fill(int i0, int j0, int i1, int j1, int value) {
            for (int i = j0; i <= j1; ++i) {
                for (int j = i0; j <= i1; ++j) {
                    this.set(j, i, value);
                }
            }
        }

        public int get(int i, int j) {
            return i >= 0 && i < this.n && j >= 0 && j < this.m ? this.array[i][j] : this.fallback;
        }

        public void update(int i, int j, int expected, int newValue) {
            if (this.get(i, j) == expected) {
                this.set(i, j, newValue);
            }
        }

        public boolean anyMatchAround(int i, int j, int value) {
            return this.get(i - 1, j) == value || this.get(i + 1, j) == value || this.get(i, j + 1) == value || this.get(i, j - 1) == value;
        }
    }

    static class ThirdFloor<C extends RSMansionConfig>
    extends RoomCollection<C> {
        private ThirdFloor(C config) {
            super("third_floor", config);
        }

        @Override
        public String get1x1(Random random) {
            return "repurposed_structures:mansions/" + this.config.mansionType + "/" + this.floor + "_1x1_rooms";
        }

        @Override
        public String get1x1Secret(Random random) {
            return "repurposed_structures:mansions/" + this.config.mansionType + "/" + this.floor + "_1x1_secret_rooms";
        }

        @Override
        public String get1x2SideEntrance(Random random, boolean isStairs) {
            return "repurposed_structures:mansions/" + this.config.mansionType + "/" + this.floor + (isStairs ? "_1x2_c_stairs" : "_1x2_rooms");
        }

        @Override
        public String get1x2FrontEntrance(Random random, boolean isStairs) {
            return "repurposed_structures:mansions/" + this.config.mansionType + "/" + this.floor + (isStairs ? "_1x2_d_stairs" : "_1x2_alternative_rooms");
        }

        @Override
        public String get1x2Secret(Random random) {
            return "repurposed_structures:mansions/" + this.config.mansionType + "/" + this.floor + "_1x2_secret_rooms";
        }

        @Override
        public String get2x2(Random random) {
            return "repurposed_structures:mansions/" + this.config.mansionType + "/" + this.floor + "_2x2_rooms";
        }

        @Override
        public String get2x2Secret(Random random) {
            return "repurposed_structures:mansions/" + this.config.mansionType + "/" + this.floor + "_2x2_secret_rooms";
        }
    }

    static class SecondFloor<C extends RSMansionConfig>
    extends RoomCollection<C> {
        private SecondFloor(C config) {
            super("second_floor", config);
        }

        @Override
        public String get1x1(Random random) {
            return "repurposed_structures:mansions/" + this.config.mansionType + "/" + this.floor + "_1x1_rooms";
        }

        @Override
        public String get1x1Secret(Random random) {
            return "repurposed_structures:mansions/" + this.config.mansionType + "/" + this.floor + "_1x1_secret_rooms";
        }

        @Override
        public String get1x2SideEntrance(Random random, boolean isStairs) {
            return "repurposed_structures:mansions/" + this.config.mansionType + "/" + this.floor + (isStairs ? "_1x2_c_stairs" : "_1x2_rooms");
        }

        @Override
        public String get1x2FrontEntrance(Random random, boolean isStairs) {
            return "repurposed_structures:mansions/" + this.config.mansionType + "/" + this.floor + (isStairs ? "_1x2_d_stairs" : "_1x2_alternative_rooms");
        }

        @Override
        public String get1x2Secret(Random random) {
            return "repurposed_structures:mansions/" + this.config.mansionType + "/" + this.floor + "_1x2_secret_rooms";
        }

        @Override
        public String get2x2(Random random) {
            return "repurposed_structures:mansions/" + this.config.mansionType + "/" + this.floor + "_2x2_rooms";
        }

        @Override
        public String get2x2Secret(Random random) {
            return "repurposed_structures:mansions/" + this.config.mansionType + "/" + this.floor + "_2x2_secret_rooms";
        }
    }

    static class FirstFloor<C extends RSMansionConfig>
    extends RoomCollection<C> {
        private FirstFloor(C config) {
            super("first_floor", config);
        }

        @Override
        public String get1x1(Random random) {
            return "repurposed_structures:mansions/" + this.config.mansionType + "/" + this.floor + "_1x1_rooms";
        }

        @Override
        public String get1x1Secret(Random random) {
            return "repurposed_structures:mansions/" + this.config.mansionType + "/" + this.floor + "_1x1_secret_rooms";
        }

        @Override
        public String get1x2SideEntrance(Random random, boolean isStairs) {
            return "repurposed_structures:mansions/" + this.config.mansionType + "/" + this.floor + "_1x2_rooms";
        }

        @Override
        public String get1x2FrontEntrance(Random random, boolean isStairs) {
            return "repurposed_structures:mansions/" + this.config.mansionType + "/" + this.floor + "_1x2_alternative_rooms";
        }

        @Override
        public String get1x2Secret(Random random) {
            return "repurposed_structures:mansions/" + this.config.mansionType + "/" + this.floor + "_1x2_secret_rooms";
        }

        @Override
        public String get2x2(Random random) {
            return "repurposed_structures:mansions/" + this.config.mansionType + "/" + this.floor + "_2x2_rooms";
        }

        @Override
        public String get2x2Secret(Random random) {
            return "repurposed_structures:mansions/" + this.config.mansionType + "/" + this.floor + "_2x2_secret_rooms";
        }
    }

    static abstract class RoomCollection<C extends RSMansionConfig> {
        protected final String floor;
        protected final C config;

        private RoomCollection(String floor, C config) {
            this.floor = floor;
            this.config = config;
        }

        public abstract String get1x1(Random var1);

        public abstract String get1x1Secret(Random var1);

        public abstract String get1x2SideEntrance(Random var1, boolean var2);

        public abstract String get1x2FrontEntrance(Random var1, boolean var2);

        public abstract String get1x2Secret(Random var1);

        public abstract String get2x2(Random var1);

        public abstract String get2x2Secret(Random var1);
    }
}

